function[cm,acm]=CMA(Observed,Modeled)
 x=Observed;
 y=Modeled;

 %x=Observed;
 %y=Modeled;
 %cm: value of the CMA   - coefficient of model accuracy
 %acm: alternative CMA  
 %How to call the function:
 %x=rand(100,1);
 %y=x*rand(100,1);
 %[cm,acm]=CMA (x,y);

n=length(x); %sample size of the observed data

Dx=zeros(n,1); %for rescaled observed series
Dy=zeros(n,1); %for rescaled modeled series
ux=zeros(n,1); 
uy=zeros(n,1);
vx=zeros(n,1); 
vy=zeros(n,1);
A=zeros(n,1);
B=zeros(n,1);
h=zeros(n,1);

%Applying penalties to modeled series
%**********************************************************
for i=1:n
    if (x(i,1)<0 && y(i,1)>=0) || (x(i,1)>0 && y(i,1)<=0) 
        h(i,1)=0;
    else
        h(i,1)=y(i,1);
    end
end

%Computing squares of the deviations from comparison baseline
%************************************************************
for i=1:n
    if (x(i,1)== 3*mean(x) && h(i,1)== 3*mean(x)) 
        A(i,1)=0;
        B(i,1)=0;
     else
         A(i,1)= min(((x(i,1)-3*mean(x))^2), (h(i,1)-3*mean(x))^2);
         B(i,1)= max(((x(i,1)-3*mean(x))^2), (h(i,1)-3*mean(x))^2); 
     end
end
 
 
if (sum(B)==0 || sum(h)==0);
    beta1=0;
else
    beta1=(sum(A)/sum(B));
end


%Re-scaling observed data
%*************************
for i=1:n
    ux(i)=sum(x>x(i));  %how many times a given value x(i) is exceeded from an array x
    vx(i)=sum(x<x(i));
    Dx(i)=vx(i)-ux(i);
end    
     
%Re-scaling modeled data
%*************************
for i=1:n
    uy(i)=sum(y>y(i));  % how many times a given value x(i) is exceeded from an array x
    vy(i)=sum(y<y(i));
    Dy(i)=vy(i)-uy(i);
end
 
%Computing linear trend slope which varies from zero to one
%***********************************************************
rc=sum(Dx.*Dy)/sqrt(sum(Dx.^2)*sum(Dy.^2)); 
 
if (mean(x)==0 && mean(h)==0) || (mean(x)==mean(h))
    thet1=1;
else
   thet1=((min((mean(x))^2,(mean(h))^2)/max((mean(x))^2,(mean(h))^2)));
end

if (std(x)==0 && std(y)==0)
    lamda1=0;
elseif (std(x)==std(y))
    lamda1=1;
else
   		lamda1= min(std(x),std(y))/max(std(x),std(y));
end
    cm=abs(rc)*beta1*thet1; %This is CMA
    acm=abs(rc)* lamda1*thet1; %This is the alternative CMA

end
